/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.uploader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import replicatorg.app.Base;
import replicatorg.uploader.FirmwareUploader;
import replicatorg.uploader.FirmwareVersion;

class FirmwareRetriever {
    File firmwareXml;
    URL firmwareSourceURL;
    private static final int TIMEOUT_MS = 10000;

    public FirmwareRetriever(File firmwareXml, URL firmwareSourceURL) {
        this.firmwareXml = firmwareXml;
        this.firmwareSourceURL = firmwareSourceURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UpdateStatus checkForUpdates() {
        UpdateStatus status;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            status = this.updateURL(this.firmwareSourceURL, this.firmwareXml, true);
            if (status == UpdateStatus.NEW_UPDATES) {
                this.retrieveNewFirmware();
            }
        }
        return status;
    }

    protected UpdateStatus updateURL(URL url, File file) {
        return this.updateURL(url, file, false);
    }

    protected UpdateStatus updateURL(URL url, File file, boolean checkParseableXML) {
        long timestamp = file.lastModified();
        if (checkParseableXML && file.exists()) {
            try {
                DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                db.parse(file);
            }
            catch (Exception e) {
                Base.logger.severe("Existing " + file.getPath() + " is not parseable; forcing refresh from web.");
                timestamp = 0L;
            }
        }
        try {
            int count;
            URLConnection urlConnection = url.openConnection();
            if (urlConnection instanceof HttpURLConnection) {
                HttpURLConnection connection = (HttpURLConnection)urlConnection;
                connection.setIfModifiedSince(timestamp);
                connection.setConnectTimeout(10000);
                connection.connect();
                if (connection instanceof HttpURLConnection) {
                    int rc = connection.getResponseCode();
                    if (rc == 304) {
                        return UpdateStatus.NO_NEW_UPDATES;
                    }
                    if (rc != 200) {
                        return UpdateStatus.NETWORK_UNAVAILABLE;
                    }
                }
            }
            InputStream content = (InputStream)urlConnection.getContent();
            FileOutputStream out = new FileOutputStream(file);
            int BUF_SIZE = 2048;
            byte[] buf = new byte[2048];
            int bytesWritten = 0;
            while ((count = content.read(buf)) != -1) {
                bytesWritten += count;
                out.write(buf, 0, count);
            }
            out.close();
            content.close();
            Base.logger.info(String.valueOf(Integer.toString(bytesWritten)) + " bytes written to " + file.getCanonicalPath());
            return UpdateStatus.NEW_UPDATES;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (SocketTimeoutException e) {
            Base.logger.log(Level.INFO, "Firmware updater: network unavailable.");
        }
        catch (UnknownHostException e) {
            Base.logger.log(Level.INFO, "Firmware updater: network unavailable.");
        }
        catch (FileNotFoundException e) {
            return UpdateStatus.RO_FILESYSTEM;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return UpdateStatus.NETWORK_UNAVAILABLE;
    }

    protected void retrieveNewFirmware() {
        Document doc = FirmwareUploader.loadFirmwareDoc();
        if (doc == null) {
            return;
        }
        NodeList list = doc.getElementsByTagName("firmware");
        int i = 0;
        while (i < list.getLength()) {
            URL url;
            Node n = list.item(i);
            String path = new FirmwareVersion(n).getRelPath();
            try {
                url = new URL(this.firmwareSourceURL, path);
                File file = Base.getUserFile(path);
                this.updateURL(url, file);
            }
            catch (MalformedURLException e) {
                Base.logger.severe("Couldn't generate URL for path " + path);
            }
            String eeprom = new FirmwareVersion(n).getEepromPath();
            if (eeprom != null) {
                try {
                    url = new URL(this.firmwareSourceURL, eeprom);
                    File file = Base.getUserFile(path);
                    this.updateURL(url, file);
                }
                catch (MalformedURLException e) {
                    Base.logger.severe("Couldn't generate URL for path " + path);
                }
            }
            ++i;
        }
    }

    public static enum UpdateStatus {
        NETWORK_UNAVAILABLE,
        NO_NEW_UPDATES,
        NEW_UPDATES,
        RO_FILESYSTEM;

    }
}

